extends Node

export (PackedScene) var Mob

var score

func _ready():
	randomize()

func game_over():
	$hud.show_game_over()
	$timerpuntaje.stop()
	$timermalos.stop()
	$musica.stop()
	$gameover.play()

func new_game():
	score = 0
	$hud.update_score(score)
	$hud.show_message("Preparate!!")
	$Jugador.start($posicioninicial.position)
	$timerinicial.start()
	$musica.play()

func _on_timerinicial_timeout():
	$timermalos.start()
	$timerpuntaje.start()

func _on_timerpuntaje_timeout():
	score +=  1
	$hud.update_score(score)

func _on_timermalos_timeout():
	$caminomalos/puntodesalida.set_offset(randi())
	var enemigos=Mob.instance()
	add_child(enemigos)
	var direction = $caminomalos/puntodesalida.rotation + PI/2
	enemigos.position = $caminomalos/puntodesalida.position
	enemigos.rotation = direction
	enemigos.set_linear_velocity(Vector2(rand_range(enemigos.min_speed, enemigos.max_speed),0). rotated(direction))
